import { Department } from '../index';

// Department service specific types
export interface DepartmentFilter {
  search?: string;
  budgetRange?: {
    min: number;
    max: number;
  };
  employeeCountRange?: {
    min: number;
    max: number;
  };
  managerId?: string;
}

export interface DepartmentSortOptions {
  field: 'name' | 'employeeCount' | 'budget';
  order: 'asc' | 'desc';
}

export interface DepartmentPaginationOptions {
  page: number;
  limit: number;
  sort?: DepartmentSortOptions;
}

export interface DepartmentListResponse {
  departments: Department[];
  total: number;
  page: number;
  limit: number;
  totalPages: number;
}

export interface DepartmentCreateRequest extends Omit<Department, 'id' | 'employeeCount'> {}

export interface DepartmentUpdateRequest extends Partial<Omit<Department, 'id'>> {}

export interface DepartmentStats {
  total: number;
  totalBudget: number;
  totalEmployees: number;
  avgBudget: number;
  avgEmployeesPerDept: number;
  budgetUtilization: number;
  departmentSizes: Array<{
    size: 'small' | 'medium' | 'large';
    count: number;
  }>;
}

export interface DepartmentBudgetAnalysis {
  departmentId: string;
  departmentName: string;
  allocatedBudget: number;
  spentBudget: number;
  remainingBudget: number;
  utilizationPercentage: number;
  costPerEmployee: number;
  budgetTrend: Array<{
    month: string;
    spent: number;
    allocated: number;
  }>;
}

export interface DepartmentEmployeeDistribution {
  departmentId: string;
  departmentName: string;
  totalEmployees: number;
  activeEmployees: number;
  inactiveEmployees: number;
  avgSalary: number;
  salaryRange: {
    min: number;
    max: number;
  };
  positionBreakdown: Array<{
    position: string;
    count: number;
  }>;
}

export interface DepartmentPerformanceMetrics {
  departmentId: string;
  departmentName: string;
  attendanceRate: number;
  productivityScore: number;
  employeeSatisfaction: number;
  turnoverRate: number;
  leaveUtilization: number;
}

export interface DepartmentReorganization {
  fromDepartmentId: string;
  toDepartmentId: string;
  employeeIds: string[];
  effectiveDate: string;
  reason: string;
}

export interface DepartmentMergeRequest {
  sourceDepartmentIds: string[];
  targetDepartment: DepartmentCreateRequest;
  mergeStrategy: 'keep_all' | 'deduplicate' | 'manual_review';
}