import { Employee } from '../index';

// Employee service specific types
export interface EmployeeFilter {
  department?: string;
  status?: Employee['status'];
  position?: string;
  search?: string;
  salaryRange?: {
    min: number;
    max: number;
  };
  hireDateRange?: {
    startDate: string;
    endDate: string;
  };
}

export interface EmployeeSortOptions {
  field: 'firstName' | 'lastName' | 'department' | 'position' | 'salary' | 'hireDate';
  order: 'asc' | 'desc';
}

export interface EmployeePaginationOptions {
  page: number;
  limit: number;
  sort?: EmployeeSortOptions;
}

export interface EmployeeListResponse {
  employees: Employee[];
  total: number;
  page: number;
  limit: number;
  totalPages: number;
}

export interface EmployeeCreateRequest extends Omit<Employee, 'id'> {}

export interface EmployeeUpdateRequest extends Partial<Omit<Employee, 'id'>> {}

export interface EmployeeStats {
  total: number;
  active: number;
  inactive: number;
  terminated: number;
  newHires: number;
  avgSalary: number;
  totalSalaryExpense: number;
  departmentDistribution: Array<{
    department: string;
    count: number;
    percentage: number;
  }>;
}

export interface EmployeeBulkOperation {
  operation: 'update' | 'delete' | 'activate' | 'deactivate';
  employeeIds: string[];
  updateData?: Partial<Employee>;
}

export interface EmployeeBulkOperationResult {
  success: boolean;
  processedCount: number;
  failedCount: number;
  errors?: Array<{
    employeeId: string;
    error: string;
  }>;
}

export interface EmployeeSearchResult {
  employees: Employee[];
  suggestions: string[];
  total: number;
}

export interface EmployeeValidationResult {
  isValid: boolean;
  errors: Array<{
    field: string;
    message: string;
  }>;
}

export interface EmployeePerformanceMetrics {
  employeeId: string;
  attendanceRate: number;
  performanceRating: number;
  leavesTaken: number;
  overtimeHours: number;
  lastReviewDate?: string;
}