import { Holiday } from '../index';

// Holiday Service Types
export interface HolidayFilter {
  year?: number;
  month?: number;
  type?: 'public' | 'company' | 'optional' | 'religious';
  organizationId?: string;
  departmentIds?: string[];
  search?: string;
}

export interface HolidayCreateRequest {
  name: string;
  date: string;
  description?: string;
  type: 'public' | 'company' | 'optional' | 'religious';
  isRecurring: boolean;
  organizationId?: string;
  departmentIds?: string[];
  color?: string;
}

export interface HolidayUpdateRequest extends Partial<HolidayCreateRequest> {
  id: string;
}

export interface HolidayListResponse {
  holidays: Holiday[];
  total: number;
  page: number;
  limit: number;
}

export interface HolidayStats {
  total: number;
  byType: Record<string, number>;
  upcoming: number;
  thisMonth: number;
  recurring: number;
}

export interface HolidayPaginationOptions {
  page: number;
  limit: number;
  sortBy?: 'date' | 'name' | 'type' | 'createdAt';
  sortOrder?: 'asc' | 'desc';
}

export interface HolidayCalendarView {
  year: number;
  month: number;
  holidays: Holiday[];
  weekends: string[];
}

export interface HolidayBulkOperation {
  operation: 'create' | 'update' | 'delete';
  holidays: Holiday[] | HolidayCreateRequest[] | string[];
}

export interface HolidayBulkOperationResult {
  success: boolean;
  created?: number;
  updated?: number;
  deleted?: number;
  failed?: number;
  errors?: string[];
}

export interface HolidayImportOptions {
  format: 'csv' | 'json' | 'ics';
  data: string | File;
  organizationId?: string;
  departmentIds?: string[];
  overwrite?: boolean;
}

export interface HolidayExportOptions {
  format: 'csv' | 'json' | 'ics' | 'pdf';
  filter?: HolidayFilter;
  year?: number;
  includeDescription?: boolean;
}

export interface HolidayConflict {
  date: string;
  holidays: Holiday[];
  type: 'duplicate' | 'overlap';
}

export interface RecurringHolidayRule {
  frequency: 'yearly' | 'monthly' | 'weekly';
  interval: number;
  endDate?: string;
  count?: number;
}